/************************************************************************
* (c) Copyright Freescale Semiconductor, Inc 2007, All Rights Reserved  *
************************************************************************/

/************************************************************************
*                                                                       *
*               EEPROM Emulation Driver for S12XS/S12P                  *
*                                                                       *
* FILE NAME     :  EED_MiddleLevel.c                                    *
* DATE          :  06.05.2008                                           *
* AUTHOR        :  Infosys Team, Mysore                                 *
* EMAIL         :  r56611@freescale.com                                 *
************************************************************************/

/******************************* CHANGES ********************************
* 0.0a   06.11.2007    Sindhu_R01     Initial Version.
* 0.1    06.20.2007    Jiben_Prakash  Added APIs: FSL_Erase()
                                      FSL_Program() FSL_ReadRecord()
* 0.2    08.02.2007    Sindhu R01     Updated to support the
                                      Cosmic compiler
* 0.3    10.17.2007    Sindhu R01     Updated code to clear the DFDIF
                                      bit and to set erasing cycles
                                      to 0 if it reaches 0xFFFE
* 1.0    04.28.2008    Sindhu R01     Updated the functions
                                      FSL_InitSector(), FSL_SwapSector(),
                                      FSL_SearchLoop(), FSL_ReadRecord(),
                                      FSL_SectorStatus() and Added
                                      the function FSL_CheckMarginLevel()
                                      to fix partial programming
                                      and dead sector errors
* 2.0    06.05.2008    Sindhu R01     Updated the functions to remove the
                                      SSD Flash Configuration sturcture.
                                      The CallBack is a global variable
                                      and the code for calling it is a
                                      compiler switch.
                                      Modified the FSL_SearchRecord()
************************************************************************/

#include "ee_emulation.h"
/* Global variables */
/* A command array which contains the data to be written to the FCCOB register. */
UINT16 commandArray[6]; /* command sequence array */

#if(CALLBACK_ENABLE == TRUE)
  /* A function pointer to the CallBack function */
  PCALLBACK      CallBack;
#endif

/***********************************************************************
*
*  Function Name    : FSL_Program
*  Description      : This function will erase a range of contiguous
                      Flash pages and verify those pages.
*  Arguments        : destination,size,sourceData
*  Return Value     : UNIT16
*
***********************************************************************/


UINT16 FSL_Program (UINT32 destination,UINT16 size,UINT16 sourceData)
{
    /* declaraion of the local variables */
    UINT16 returnCode;
    UINT32 source;

    /* If CallBack is enabled, then serve callback function */
    #if(CALLBACK_ENABLE == TRUE)
        CallBack();
    #endif

    /* source data is passed into the function FSL_Program()
       DFlashProgram and FlashProgramVerify expects source address.
       source will have the address of the source data */
    source = (UINT32)&sourceData;


    /* DFlashProgram function called */
    returnCode=DFlashProgram(destination,size,source);

    if(returnCode == SGF_OK)
    {
        /* DFlashProgramVerify function called */
        //returnCode=FlashProgramVerify(destination,size,source);
        if(returnCode != SGF_OK)
        {
            return(EED_ERROR_VERIFY);
        }
    }

    /* return the final return code based on the loop outcome */
    return(returnCode);
}

/***********************************************************************
*
* End of file EED_MiddleLevel.c
*
***********************************************************************/